import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.*;
import java.awt.*;
import java.awt.geom.Point2D;


/* Length of the Day Application - main java file
* 
* Developed by Cristina Vinas Vinuales - Institute for Biocomputation and Physics of Complex Systems (BIFI) - Zaragoza
* for Science on Stage on January 2012
* 
*/

public class lengthofday implements ActionListener{

	 /**
	 * @param args
	 */
	 public static void main(String[] args) {
	        //Schedule a job for the event-dispatching thread:
	        //creating and showing this application's GUI.
	        javax.swing.SwingUtilities.invokeLater(new Runnable() {
	            public void run() {
	            	lengthofday p = new lengthofday();
	                
	            }
	        });
	    }
	 
	 /***********************************************************************************************************************/
		
	 public lengthofday() {
	 	
		//construction of the main window
		MainFrame = new JFrame("Length of the Day General Aplication");
		MainFrame.setPreferredSize(new Dimension(1100,400));
   		//MainFrame.setBackground(Color.white);
   		MainFrame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
   		
   		CreatePanels();
   		
		//set visible the main window
	   	MainFrame.pack();
	   	MainFrame.setVisible(true);
	 }
	 
	 /***********************************************************************************************************************/
	 
	 private void CreatePanels() {
		
		
		JPanel panIzq = new JPanel(new GridLayout(11,1,5,1));
		   			   		
			panIzq.add(createEmptyText());				
			
			JPanel panDate = new JPanel();
				panDate.add(createText("Day: "));			   	
				GetTxtDay = new JTextField("",3);
				GetTxtDay.setEditable(true);	   		
				panDate.add(GetTxtDay);
			
				panDate.add(createText("Month: "));			  	
				GetTxtMonth = new JTextField("",3);
				GetTxtMonth.setEditable(true);	   		
				panDate.add(GetTxtMonth);
			
				panDate.add(createText("Year: "));
				GetTxtYear = new JTextField("",5);
				GetTxtYear.setEditable(true);	   		
				panDate.add(GetTxtYear);
			panIzq.add(panDate);
			   	
			panIzq.add(createEmptyText());			   	
			
			JPanel panLat = new JPanel();
			panLat.add(createText("Latitude: "));
			
			JPanel lats = new JPanel();
				GetTxtLatDeg = new JTextField("",2);
				GetTxtLatDeg.setEditable(true);	  
				//GetTxtLatDeg.setBorder(javax.swing.BorderFactory.createEmptyBorder());
				lats.add(GetTxtLatDeg);
				
				JTextField TxtLatDeg = new JTextField("",1);
				TxtLatDeg.setEditable(false);	
				TxtLatDeg.setBorder(javax.swing.BorderFactory.createEmptyBorder());
				lats.add(TxtLatDeg);
				
				GetTxtLatMin = new JTextField("",2);
				GetTxtLatMin.setEditable(true);	
				//GetTxtLatMin.setBorder(javax.swing.BorderFactory.createEmptyBorder());
				lats.add(GetTxtLatMin);
				
				JTextField TxtLatMin = new JTextField("'",1);
				TxtLatMin.setEditable(false);
				TxtLatMin.setBorder(javax.swing.BorderFactory.createEmptyBorder());
				lats.add(TxtLatMin);
				
				GetTxtLatSec = new JTextField("",3);
				GetTxtLatSec.setEditable(true);	
				//GetTxtLatSec.setBorder(javax.swing.BorderFactory.createEmptyBorder());
				lats.add(GetTxtLatSec);
				
				JTextField TxtLatSec = new JTextField("''",1);
				TxtLatSec.setEditable(false);
				TxtLatSec.setBorder(javax.swing.BorderFactory.createEmptyBorder());
				lats.add(TxtLatSec);
				
				GetTxtLatDir = new JTextField("",2);
				GetTxtLatDir.setEditable(true);	
				//GetTxtLatDir.setBorder(javax.swing.BorderFactory.createEmptyBorder());
				lats.add(GetTxtLatDir);
				
				JTextField TxtLatDir = new JTextField("(N or S)",4);
				TxtLatDir.setEditable(false);	
				TxtLatDir.setBorder(javax.swing.BorderFactory.createEmptyBorder());
				lats.add(TxtLatDir);
			
			panLat.add(lats);
			panIzq.add(panLat);
			
			JPanel panLon = new JPanel();
			panLon.add(createText("Longitude: "));			  	
			JPanel lons = new JPanel();
				GetTxtLonNum = new JTextField("",2);
				GetTxtLonNum.setEditable(true);	  
				//GetTxtLonNum.setBorder(javax.swing.BorderFactory.createEmptyBorder());
				lons.add(GetTxtLonNum);
			panLon.add(lons);			
			panLon.add(createText(" GMT hour (ex: Berlin +2.0)"));		
			panIzq.add(panLon);
			
			JPanel panError = new JPanel();
			txtError = new JTextArea(" ");
			Font font3 = new Font("Verdana", Font.ITALIC, 11);
			txtError.setSize(280, 200);
		   	txtError.setFont(font3);
		   	txtError.setForeground(Color.RED);
		   	Color c = new Color(240,240,240,255);
		   	txtError.setBackground(c);
		   	txtError.setLineWrap(true);
		   	txtError.setWrapStyleWord(true);
		   	txtError.setAlignmentX(JTextArea.RIGHT_ALIGNMENT);
			//txtError.setHorizontalAlignment(JTextField.LEFT);
			txtError.setBorder(javax.swing.BorderFactory.createEmptyBorder());
			txtError.setEditable(false);
			panError.add(txtError);
			panIzq.add(panError);
			
			JPanel butC = new JPanel();
			buttonClear = new JButton("Clear values");
			buttonClear.addActionListener(this);
			butC.add(buttonClear);
			buttonCalc = new JButton("Calculate");
			buttonCalc.addActionListener(this);
			butC.add(buttonCalc);
			panIzq.add(butC);
						
			JPanel panOrto = new JPanel(new FlowLayout(FlowLayout.CENTER)); //TODO: LEFT OR CENTERED??
			panOrto.add(createText("Sunrise: "));			   	
			SetTxtOrto = new JTextArea(" ");
			SetTxtOrto.setEditable(false);	
			panOrto.add(SetTxtOrto);
			panOrto.add(createText(" a.m"));	
			panIzq.add(panOrto);
			
			JPanel panOcaso = new JPanel();
			panOcaso.add(createText("Sunset: "));			   	
			SetTxtOcaso = new JTextArea(" ");
			SetTxtOcaso.setEditable(false);	   		
			panOcaso.add(SetTxtOcaso);
			panOcaso.add(createText(" p.m"));
			panIzq.add(panOcaso);
			
			JPanel panLength = new JPanel();
			panLength.add(createText("Length of Day: "));
			SetTxtDuration = new JTextArea(" ");
			SetTxtDuration.setEditable(false);	   		
			panLength.add(SetTxtDuration);
			panLength.add(createText(" hours"));
			panIzq.add(panLength);
			
			JPanel buttons = new JPanel();
			buttonReset = new JButton("Clear Sun Paths");
			buttonReset.addActionListener(this);
			buttons.add(buttonReset);
			panIzq.add(buttons);
			
			
	   	//p1.add(panIzq,BorderLayout.WEST);
	   	
		MainFrame.add(panIzq,BorderLayout.WEST);
			
	   	//Tab Graphic Representation
	   	mainGraph = new representation();
	   	MainFrame.add(mainGraph,BorderLayout.CENTER);
	   	
	   	//set default values
	   	GetTxtDay.setText("21");
	   	GetTxtMonth.setText("3");
	   	GetTxtYear.setText("2012");
	   	GetTxtLatDeg.setText("40");
	   	GetTxtLatMin.setText("0");
	   	GetTxtLatSec.setText("0");
	   	GetTxtLatDir.setText("N");
	   	GetTxtLonNum.setText("0");
	   	 
	 }
	 
	 /***********************************************************************************************************************/
	 private JTextField createEmptyText(){
		 
		JTextField txtEmpty = new JTextField("");
		txtEmpty.setBorder(javax.swing.BorderFactory.createEmptyBorder());
		txtEmpty.setEditable(false);
		return txtEmpty;
	 }
	 
	 /***********************************************************************************************************************/
	 
	 private JTextField createText(String txt){
		 
		JTextField txtFill = new JTextField(txt);
		txtFill.setBorder(javax.swing.BorderFactory.createEmptyBorder());
		txtFill.setEditable(false);
		return txtFill;
	 }
	 
	 /***********************************************************************************************************************/
	 
	 public void actionPerformed(ActionEvent e) {
		 
		 if (e.getSource() == buttonCalc)  {
			 calculateLength();
		 }
		 if (e.getSource() == buttonClear)  {
			 
			//set default values
		   	GetTxtDay.setText("");
		   	GetTxtMonth.setText("");
		   	GetTxtYear.setText("");
		   	GetTxtLatDeg.setText("");
		   	GetTxtLatMin.setText("");
		   	GetTxtLatSec.setText("");
		   	GetTxtLatDir.setText("");
		   	GetTxtLonNum.setText("");
		   	SetTxtOrto.setText("");
		   	SetTxtOcaso.setText("");
		   	SetTxtDuration.setText("");
		   	txtError.setText("");
		 }
		 
		 if (e.getSource() == buttonReset)  {
			 
			 mainGraph.deleteRepresentations();
			 mainGraph.repaint();
		 }
		 
	 }
	 /***********************************************************************************************************************/
	 
	 public void calculateLength() {
		 
		 boolean validData = checkInputData();
		 
		 //Proceed to calculate
		 if (validData) {
			 
			txtError.setText(" ");
			SetTxtOrto.setText(" ");
			SetTxtOcaso.setText(" ");
			SetTxtDuration.setText(" ");
			int day = Integer.parseInt(GetTxtDay.getText()); 
			int month = Integer.parseInt(GetTxtMonth.getText()); 
			int year = Integer.parseInt(GetTxtYear.getText()); 
			
			int latDeg = Integer.parseInt(GetTxtLatDeg.getText());
			int latMin = Integer.parseInt(GetTxtLatMin.getText());
			int latSeg = Integer.parseInt(GetTxtLatSec.getText());
			char latDir = GetTxtLatDir.getText().charAt(0);;
			
			double latPlace_radians = (latDeg + latMin/60.0 + latSeg/3600.0) * Math.PI/180.;
			if ((latDir == 's') || (latDir =='S'))
				latPlace_radians = 2.0*Math.PI - latPlace_radians;
			double lonPlace_hours = Integer.parseInt(GetTxtLonNum.getText());
			
			//Step 1: current day
			int a = (14 - month) / 12;
			int y = year + 4800 - a;
			int m = month + 12*a - 3;
			 
			float JDN = (float) (day + (153*m + 2)/5 + 365*y + (y/4) - (y/100) + (y/400) - 32045);
			float JD = (float) (JDN + (12-12)/24 + 0/1440 + 0/86400); //at 12.00 am
			
			//Step 2: to Julian centuries
			double T = (JD - 2451545) / 36525;
			double U = T / 100.0;
						
			//Step 3: determine the longitud of the Sun
			double lonSun =  (4.9353929 + 62833.1961680 * U +	Math.pow(10,-7) * escalarProd(U)) % (2.0*Math.PI); 
						
			//Step 4: calculate the oblicuity of the ecliptic
			double oblic = 0.4090928 - 0.0226938 * U + Math.pow(10,-7) * (-75. * Math.pow(U,2) + 96926. * Math.pow(U,3) - 2491. * Math.pow(U,4) - 12104. * Math.pow(U,5) + (446. * Math.cos(NutA1(U)) + 28. * Math.cos(NutA2(U))));
			//double oblic = 0.4090928 - 0.0226938 * T + Math.pow(10,-7) * (-75. * Math.pow(T,2) + 96926. * Math.pow(T,3) - 2491. * Math.pow(T,4) - 12104. * Math.pow(T,5) + (446. * Math.cos(NutA1(T)) + 28. * Math.cos(NutA2(T))));
			 
			
			//Step 5: determinate delta and alfa of the Sun
			double sinDeltaSun = Math.sin(oblic) * Math.sin(lonSun);
			double DeltaSun = Math.asin(sinDeltaSun) % (2.0*Math.PI);
			if (DeltaSun < 0 )
				DeltaSun = DeltaSun + (2.0*Math.PI);
			
			//double tanAlfaSun = Math.cos(oblic) * Math.tan(lonSun);
			double AlfaSun = Math.atan2(Math.cos(oblic) * Math.sin(lonSun), Math.cos(oblic) * Math.cos(lonSun)) ;
			
			//Step 6: H_0 is the hour angle in the sunset, and belongs to [0_12 hours]
			double H0 = Math.acos(- Math.tan(DeltaSun)* Math.tan(latPlace_radians)) % Math.PI;
			//double H0_hours = (H0 * 24 / (2.0 * Math.PI));
			
			//Step 7: sidereal time ST in hours (has to be in [0,2PI]
			double STsunshine = (AlfaSun - H0);
			double STsunset = (AlfaSun + H0);			
			
			if (STsunset > (2.0*Math.PI))
				STsunset = STsunset % (2.0*Math.PI);
			if (STsunset < 0)
				STsunset = STsunset + (2.0*Math.PI);
			
			if (STsunshine > (2.0*Math.PI))
				STsunshine = STsunshine % (2.0*Math.PI);
			if (STsunshine < 0)
				STsunshine = STsunshine + (2.0*Math.PI);
			
						
			double STsunset_hours = (STsunset * 24 / ( 2.0*Math.PI)) % 24;
			double STsunshine_hours = (STsunshine * 24 / ( 2.0*Math.PI)) % 24;
			
			//Step 8: conversion from sidereal time ST to universal time UT for each
			double GMST0_secs = 6.0 * 3600 + 41 * 60 + 50.54841 + 8640184.812866 * T + 0.093104 * Math.pow(T,2) + 0.0000062 * Math.pow(T,3);
			double GMST0_hours = (GMST0_secs / 3600) % 24;
			
			
			double UTsunset = 0.0;
			UTsunset = 0.9972696 * (STsunset_hours - GMST0_hours - lonPlace_hours);
			if (UTsunset < 0) {
				UTsunset = (24 + UTsunset) ;
			}
			
			double UTsunshine = 0.9972696 * (STsunshine_hours - GMST0_hours - lonPlace_hours);
			if (UTsunshine < 0) {
				UTsunshine = (24 + UTsunshine);
			}
			
			if (STsunset < STsunshine) {
				STsunset += 2.0*Math.PI;
				double sth = STsunset * 24.0 / ( 2.0*Math.PI);
				UTsunset = 0.9972696 * (sth - GMST0_hours - lonPlace_hours); // 24 - ?
				if (UTsunset < 0)
					UTsunset = (24 - UTsunset) % 24;
			}
			
			//Step 9: Length of the day
			double LoD = UTsunset - UTsunshine;
						
			UTsunset = UTsunset % 24;
			UTsunshine = UTsunshine % 24;
						
			try{
				//show values
				SetTxtOrto.setText(Double.toString(UTsunshine).substring(0, 5));
				SetTxtOcaso.setText(Double.toString(UTsunset).substring(0, 5));
				SetTxtDuration.setText(Double.toString(LoD).substring(0, 5));
				
				mainGraph.recordRepresentation(day, month, year, lonPlace_hours, latPlace_radians, UTsunshine, UTsunset);
				
				for (double val= STsunshine; val <= STsunset + 0.05; val+= 0.1) {			
					double theCosZ = Math.cos(DeltaSun) * Math.cos(val - AlfaSun) * Math.cos(latPlace_radians) + Math.sin(DeltaSun) * Math.sin(latPlace_radians);
					double Z = Math.acos(theCosZ); //radians
					double theHeight = 90 - (Z * 180/Math.PI);				
					double UTval = 0.9972696 * ((val * 24.0 / ( 2.0*Math.PI)) - GMST0_hours - lonPlace_hours);
					if (UTval < 0) {
						UTval = (24 + UTval) ;
					}		
					mainGraph.addPointLastRecord(new Point2D.Double(15 + UTval*32, 340 - theHeight*3));				
				}
			}
			catch (StringIndexOutOfBoundsException e){
				txtError.setText("For the day and latitude requested there are no sunset and no sunrise");
			}
			
			
			mainGraph.repaint();
			
		 }
	 }
	 /***********************************************************************************************************************/
	 
	 private double escalarProd(double myT) {
		 
		 //1) alfaSun + nuSun * T
		 double addition[] = null;
		 addition = new double[50];
		 
		 for (int i=0; i < 50; i++) {			 
			 addition[i] = 0.0;
			 addition[i] = alfaSun[i] + (nuSun[i] * myT);
		 }
		 
		 //2) lSun . sin( alfaSun + nuSun * T)  escalar product
		 double pesc = 0.0;
		 for (int k=0; k < 50; k++) {
			 pesc = pesc + lSun[k] * Math.sin(addition[k]);  
			 
		 }
		 
		 return pesc;
	 }
	 
	 /***********************************************************************************************************************/
	 
	 private double NutA1 (double value){
		 
		 double a = 2.18 - 3375.70 * value + 0.36 * value * value;
		 return a;
		 
	 }
	 
	 /***********************************************************************************************************************/
	 	 
	 private double NutA2 (double value){
		 
		 double b = 3.51 + 125666.39 * value + 0.10 * value * value;
		 return b;
		 
	 }
	 /***********************************************************************************************************************/
		
	 private boolean checkInputData() {
		 
		 boolean validData = true;
			
		 //Get the input data
		 int day = 0; 
		 int month = 0; 
		 int year = 0; 
		 try {
			 day = Integer.parseInt(GetTxtDay.getText());
			 if ((day < 1) || (day > 31)) {
				 validData = false;
				 txtError.setText("not a valid 'Day' for a day");
			 }
		 }
		 catch (NumberFormatException e){
			 validData = false;
			 txtError.setText("the 'Day' should be a number");
		 }
		 
		 try {
			 month = Integer.parseInt(GetTxtMonth.getText());
			 if ((month < 1) || (month > 12)) {
				 validData = false;
				 txtError.setText("not a valid 'Month' for a month");
			 }
			 else {
				 if ((month==4) || (month == 6) || (month == 9) || (month == 11)) {
					 if (day > 30) {
						 validData = false;
						 txtError.setText("your month has as much 30 days ");
					 }
				 }
				 if ((month==2) & (day > 29)) {
					 validData = false;
					 txtError.setText("your month has as much 28 or 29 days ");
				 }				 
			 }
		 }
		 catch (NumberFormatException e){
			 validData = false;
			 txtError.setText("the 'Month' should be a number");
		 }
		 
		 try {
			 year = Integer.parseInt(GetTxtYear.getText());
			 if (year < 1900) {
				 validData = false;
				 txtError.setText("the 'Year' should be bigger than '1900'");
			 }
		 }
		 catch (NumberFormatException e){
			 validData = false;
			 txtError.setText("the 'Year' should be a number");	 
		 }
		 
		 int latdeg = 0;
		 int latmin = 0;
		 float latsec = 0;
		 char latdir = 'N'; 
		 try {
			 latdeg = Integer.parseInt(GetTxtLatDeg.getText());
			 if ((latdeg > 80) || (latdeg < 1)) {
				 validData = false;
				 txtError.setText("degrees of latitude between 1 and 80");
			 }
		 }
		 catch (NumberFormatException e){
			 validData = false;
			 txtError.setText("Latitude degrees should be an integer");	 
		 }
		 
		 try {
			 latmin = Integer.parseInt(GetTxtLatMin.getText());
			 if ((latmin > 60) || (latmin < 0)) {
				 validData = false;
				 txtError.setText("minutes of latitude between 0 and 60");
			 }
		 }
		 catch (NumberFormatException e){
			 validData = false;
			 txtError.setText("Latitude minutes should be an integer");	 
		 }
		 try {
			 latsec = Integer.parseInt(GetTxtLatSec.getText());
			 if ((latsec > 60) || (latsec < 0)) {
				 validData = false;
				 txtError.setText("seconds of latitude between 0 and 60");
			 }
		 }
		 catch (NumberFormatException e){
			 validData = false;
			 txtError.setText("Latitude seconds should be an integer");	 
		 }
		 
		latdir = GetTxtLatDir.getText().charAt(0);
		if ((latdir != 'n') && (latdir != 'N') && (latdir != 's') && (latdir != 'S')) {			
			 validData = false;
			 txtError.setText("direction of latitude should be 'n','N','s' or 'S'");
		}
		
		int lon = 0;
		try {
			 lon = Integer.parseInt(GetTxtLonNum.getText());
			 if ((lon > 12) || (lon < -12)) {
				 validData = false;
				 txtError.setText("Longitude between -12 and 12");
			 }
		 }
		 catch (NumberFormatException e){
			 validData = false;
			 txtError.setText("Longitud should be a number");	 
		 }
		 return validData;
	 }
	 
	 /***********************************************************************************************************************/
	// Variables declaration - do not modify
	 public JFrame MainFrame;
	 
	 JTextField GetTxtDay;
	 JTextField GetTxtMonth;
	 JTextField GetTxtYear;
	 
	 JTextField GetTxtLatDeg;
	 JTextField GetTxtLatMin;
	 JTextField GetTxtLatSec;
	 JTextField GetTxtLatDir;
	 
	 JTextField GetTxtLonNum;
	 
	 JTextArea SetTxtOrto;
	 JTextArea SetTxtOcaso;
	 JTextArea SetTxtDuration;
	 
	 JTextArea txtError;
	 
	 JButton buttonCalc;
	 JButton buttonClear;
	 JButton buttonReset;
	 
	 representation mainGraph;
	 	
	 static int lSun[] = { 403406, 195207, 119433, 112392,   3891,   2819,   1721,    0,    660,    350,    334,    314,    268,    242,    234,	158,    132,    129,    114,     99,     93,     86,     78,	72,     68,     64,     46,     38,     37,     32,     29,	28,     27,     27,     25,     24,     21,     21,     20,	18,     17,     14,     13,     13,     13,     12,     10,	10,     10,     10 };
	 static double alfaSun[] = { 4.721964 ,5.937458 ,1.115589 ,5.781616 ,5.5474 ,	1.5120  ,4.1897  ,1.163   ,5.415   ,4.315   ,4.553   ,	5.198   ,5.989   ,2.911   ,1.423   ,0.061   ,2.317   ,	3.193   ,2.828   ,0.52    ,4.65    ,4.35    ,2.75    ,	4.50    ,3.23    ,1.22    ,0.14    ,3.44    ,4.37    ,	1.14    ,2.84    ,5.96    ,5.09    ,1.72    ,2.56    ,	1.92    ,0.09    ,5.98    ,4.03    ,4.27    ,0.79    ,	4.24    ,2.01    ,2.65    ,4.98    ,0.93    ,2.21    ,	3.59    ,1.50    ,2.55    };
	 static double nuSun[] = { 1.621043 ,62830.348067 ,62830.821524 ,62829.634302 ,	125660.5691   ,125660.9845   , 62832.4766   ,     0.813    ,	125659.310 , 57533.850 ,   -33.931 ,777137.715 , 78604.191 ,	5.412 , 39302.098 ,   -34.861 ,115067.698 , 15774.337 ,	5296.670 , 58849.27  ,  5296.11  , -3980.70  , 52237.69  ,	55076.47  ,   261.08  , 15773.85  ,188491.03  , -7756.55  ,	264.89  ,117906.27  , 55075.75  , -7961.39  ,188489.81  ,	2132.19  ,109771.03  , 54868.56  , 25443.93  ,-55731.43  ,	60697.74  ,  2132.79  ,109771.63  , -7752.82  ,188491.91  ,	207.81  , 29424.63  ,    -7.99  , 46941.14  ,   -68.29  ,	21463.25  ,157208.40  };

	 
	 
}

